using UnityEngine;
using Haply.HardwareAPI.Internal.Detection;

namespace Haply.HardwareAPI.Unity.Editor
{
    internal static class AutoDetectUtility
    {
        internal static AutoDetect autoDetect => s_AutoDetect;

        private static AutoDetect s_AutoDetect;

        private static int s_AutoDetectClients = 0;

        private static void Initialize ()
        {
            s_AutoDetect = new AutoDetect( flags: AutoDetectFlags.GetHandedness | AutoDetectFlags.GetNames | AutoDetectFlags.FilterPorts | AutoDetectFlags.KeepLogs );
            s_AutoDetect.Start();
        }

        private static void Dispose ()
        {
            s_AutoDetect?.Dispose();
            s_AutoDetect = default;
        }

        internal static void IncrementAutoDetectClients ()
        {
            if ( s_AutoDetect == default )
            {
                if ( !Application.isPlaying )
                {
                    Initialize();
                }
            }

            s_AutoDetectClients++;
        }

        internal static void DecrementAutoDetectClients ()
        {
            if ( s_AutoDetectClients > 0 )
            {
                if ( --s_AutoDetectClients == 0 )
                {
                    Dispose();
                }
            }
        }

        internal static void Retry ()
        {
            if ( s_AutoDetectClients > 0 )
            {
                Dispose();
                Initialize();
            }
        }
    }
}